/*  Beispiel 6.5.3 "A/D Wandler 10 bit"
*   
*   In diesem Beispiel wird die am internen 10bit ADC gemessene Spannung auf dem OLED angezeigt.
*/

#include <SSD1306Wire.h>   

// Initialize the OLED display using Wire library
SSD1306Wire  display(0x3c, 4, 5);   

int adc_esp8266 = 0;  // ADC im ESP8266 hat Index 0
int analogIN = 0;
float UMess;


void setup(void)
{
  Serial.begin(115200); // starte seriellen Monitor mit Baudrate 115200
  
  display.init();   // OLED init
  display.clear();
}

void loop(void)
{
  analogIN = analogRead(adc_esp8266);   // Liest Spannung als Rohwert: 0 = 0V bis 1023 = 1V-1LSB 
  UMess = ((float)analogIN/1024)*10.0;  // Umrechnen in Volt mit analogIN/Auflösung (*1Volt), *10 wegen 10:1 Teiler am ADC
  String UMess_str =  String(UMess, 2); // Spannungswert in String umwandeln für OLED Ausgabe mit Anzeige von 2 Nachkommastellen
  
  Serial.print(UMess);
  Serial.print(" V\t  digitaler Rohwert: ");
  Serial.println(analogIN);
  
  display.clear();      //OLED löschen

  display.setTextAlignment(TEXT_ALIGN_LEFT);
  display.setFont(ArialMT_Plain_24);
  display.drawString(0, 0, "ADC 10 bit:");
  display.setTextAlignment(TEXT_ALIGN_RIGHT);
  display.setFont(ArialMT_Plain_24);
  display.drawString(120, 32, UMess_str + " V");
  
  display.display();    // Ausgabe auf OLED
  
  delay(1000);
}





