/*  Beispiel 6.5.4 "A/D Wandler 18 bit"
*   
*   In diesem Beispiel wird sowohl mit dem internen 10bit ADC 
*   als auch dem I2C 18bit ADC gemessen und die Spannung auf dem OLED angezeigt.
*/

#include <SSD1306Wire.h>
#include <MCP3421.h>
MCP3421 MCP = MCP3421();
int adc_esp8266 = 0;  // ADC im ESP8266 hat Index 0

// Initialize the OLED display using Wire library
SSD1306Wire  display(0x3c, 4, 5);

int analogIN_10bit;
double analogIN_18bit;
float UMess_10bit, UMess_18bit;

//Korrekturfaktor berechnen: Korrekturfaktor = UMess(Multimeter) / U(Anzeige Brick)
//hier Korrketurfaktor für 10bit ADC definieren
const float Correction_10bit = 1.043;
//hier Korrketurfaktor für 18bit ADC definieren
const float Correction_18bit = 1.0067;


void setup(void)
{
  Serial.begin(115200); // starte seriellen Monitor mit Baudrate 115200

  Serial.println("18 bit ADC versus 10 bit ADC");  
  Wire.begin();
  delay(2000);
 
  MCP.init(0x68,3,0);   // Init MCP3421: I2C-Adresse, 18 Bit Modus, keine Verstärkung
  
  display.init();   // OLED init
  display.clear();
}

void loop(void)
{
  analogIN_10bit = analogRead(adc_esp8266);    // Liest Spannung als Rohwert: 0 = 0V, 1023 = 1V-1LSB 
  UMess_10bit = ((float)analogIN_10bit/1024) * 10.0;  // Umrechnen in Volt analogIN_10bit/Auflösung (*1Volt), *10 wegen 10:1 Teiler am ADC
  // Die nächste Zeile zur Ermittlung des Korrekturfaktors mittels Multimeter-Messung auskommentieren
  UMess_10bit = UMess_10bit*Correction_10bit;  // Korrekturfaktor einrechnen (waehrend Abgleich auskommentieren)
  String UMess_10bit_str =  String(UMess_10bit, 2); // Spannungswert in String umwandeln für OLED Ausgabe mit 2 Nachkommastellen
  
  Serial.print("10 bit:\t");
  Serial.print(UMess_10bit);
  Serial.println(" V\t");

  analogIN_18bit=MCP.getDouble();       // Liest Spannung als Double-Werte aus I2C ADC, Eingangsbereich: 0 bis 2,048V
  UMess_18bit = analogIN_18bit*10.0;    // *10 wegen 10:1 Teiler am ADC
  // Die nächste Zeile zur Ermittlung des Korrekturfaktors mittels Multimeter-Messung bitte auskommentieren!
  UMess_18bit = UMess_18bit*Correction_18bit;  // Korrekturfaktor einrechnen (waehrend Abgleich auskommentieren)
  String UMess_18bit_str = String(UMess_18bit, 4); // Spannungswert in String umwandeln für OLED Ausgabe mit 4 Nachkommastellen

  Serial.print("18 bit:\t");
  Serial.print(UMess_18bit_str);
  Serial.println(" V\t");
  Serial.println();
 
  display.clear();

  display.setTextAlignment(TEXT_ALIGN_LEFT);
  display.setFont(ArialMT_Plain_16);
  display.drawString(0, 0, "18 bit: ");
  display.setTextAlignment(TEXT_ALIGN_RIGHT);
  display.setFont(ArialMT_Plain_16);
  display.drawString(127, 0, UMess_18bit_str + " V");

  display.setTextAlignment(TEXT_ALIGN_LEFT);
  display.setFont(ArialMT_Plain_16);
  display.drawString(0, 32, "10 bit: ");
  display.setTextAlignment(TEXT_ALIGN_RIGHT);
  display.setFont(ArialMT_Plain_16);
  display.drawString(127, 32, UMess_10bit_str + " V");
  
  display.display();    // Ausgabe beider Spannungswerte auf OLED
  
  delay(1000);
}





