/*  Beispiel 6.6.1 "WLAN CLient mit OLED/Seriell Ausgabe"
 *   
 */


#include <ESP8266WiFi.h>
#include <SSD1306Wire.h>


// Initialisiert das OLED Display 
SSD1306Wire  display(0x3c, 4, 5);


boolean connect_to_WLAN(); //eine Funktion um die WLAN Verbindung aufzubauen, siehe unten
boolean WLAN_connect_status =false;

//const char* ssid = "mein_wlan_name";  //hier eigenes WLAN Namen (SSID) eintragen 
//const char* password = "mein_wlan_passwort"; //hier eigenes WLAN Passwort eintragen


void setup() {
  Serial.begin(115200);
  // Initialisiert die OLED graphische Anzeige.
  display.init();

  //display.flipScreenVertically();
  display.setFont(ArialMT_Plain_10);
  //Variable für den erfolgreichen oder nicht erfolgreichen WLAN Connect
  WLAN_connect_status = connect_to_WLAN();

}

void loop() {
  
  if(WLAN_connect_status){ //falls die WLAN Verbindung erfolgreich war, zeige dies in der seriellen Console und im OLED Display
    display.clear();
    display.setTextAlignment(TEXT_ALIGN_LEFT);
    //display->flipScreenVertically(); // Anzeige spiegeln
    display.setFont(ArialMT_Plain_10);
 
    String state = "N/A";
      if (WiFi.status() == 0) state = "Idle";
      else if (WiFi.status() == 1) state = "NO SSID AVAILBLE";
      else if (WiFi.status() == 2) state = "SCAN COMPLETED";
      else if (WiFi.status() == 3) state = "CONNECTED";
      else if (WiFi.status() == 4) state = "CONNECT FAILED";
      else if (WiFi.status() == 5) state = "CONNECTION LOST";
      else if (WiFi.status() == 6) state = "DISCONNECTED";
  
      //String für WLAN Namen und Signalstärke
      String wlan_oled= "WLAN: " + (String)WiFi.SSID() +" "+ (String)WiFi.RSSI()+" dBm";  
      display.drawString(5, 0, wlan_oled);

      //Verbindungsstatus
      display.drawString(5, 10, state);
           
      //IP Adresse
      String ip_oled ="IP: " + (String)WiFi.localIP()[0] + "." + (String)WiFi.localIP()[1] + "." + (String)WiFi.localIP()[2] + "." + (String)WiFi.localIP()[3];  
      display.drawString(5, 20, ip_oled);
       
      //IP Gateway
      String gw_oled= "GW: " + (String)WiFi.gatewayIP()[0] + "." + (String)WiFi.gatewayIP()[1] + "." + (String)WiFi.gatewayIP()[2] + "." + (String)WiFi.gatewayIP()[3]; 
      display.drawString(5, 30, gw_oled);
      
      //Subnetzmaske
      String mask_oled= "NET: " + (String)WiFi.subnetMask()[0] + "." + (String)WiFi.subnetMask()[1] + "." + (String)WiFi.subnetMask()[2] + "." + (String)WiFi.subnetMask()[3]; 
      display.drawString(5, 40, mask_oled);
  
      display.display();
      delay(1000); 
    
      } else { //falls die WLAN Verbindung gescheitert ist, zeige eine Status Meldung
        display.clear();
        display.setTextAlignment(TEXT_ALIGN_LEFT);
        //display->flipScreenVertically(); // Anzeige spiegeln
        display.setFont(ArialMT_Plain_10);
        String state = "N/A";
          if (WiFi.status() == 0) state = "Idle";
          else if (WiFi.status() == 1) state = "NO SSID AVAILBLE";
          else if (WiFi.status() == 2) state = "SCAN COMPLETED";
          else if (WiFi.status() == 3) state = "CONNECTED";
          else if (WiFi.status() == 4) state = "CONNECT FAILED";
          else if (WiFi.status() == 5) state = "CONNECTION LOST";
          else if (WiFi.status() == 6) state = "DISCONNECTED";
      display.drawString(5, 10, state); 
      display.display();
      delay(1000); 
     }
}


      
/*
 * Eine Funktion um die WLAN Verbindung aufzubauen, mit einem Fortschrittsbalken
 */
boolean connect_to_WLAN(){ //eine Funktion um die WLAN Verbindung aufzubauen
  boolean state = true;
  int i = 0;
  
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  Serial.println("");
  Serial.println("Connecting to WLAN Access Point in client mode");

  // Da manche Access Points langsamer antworten als andere, müssen wir auf die Antwort warten, 25 Zyklen
  Serial.print("Connecting ...");
  while (WiFi.status() != WL_CONNECTED) {  //solange WLAN nicht verbunden ist, zeige Fortschrittsbalken im Display und Punkte in der Console
    delay(500);
    Serial.print(".");
    int progress = i*4;
    
    display.clear();
    display.drawProgressBar(0, 32, 120, 10, progress);
    display.setTextAlignment(TEXT_ALIGN_CENTER);
    display.drawString(64, 15, String(progress) + "%");
    
    if (i > 25){
      state = false;
      break;
    }
    display.display();
    i++;
  }
  
  if (state){  //falls Verbindung erfolgreich, zeige WLAN Namen und die DHCP IP Adresse in der Console
    Serial.println("");
    Serial.print("Connected to ");
    Serial.println(ssid);
    Serial.print("IP address: ");
    Serial.println(WiFi.localIP());
  }
  else { //gebe Fehlermeldung in der Console aus, falls Verbindung fehlgeschlagen
    Serial.println("");
    Serial.println("Connection failed.");
  }
  
  return state;
}


