/*  Beispiel 6.6.3 "Temperatur und Feuchtigkeit messen mit DHT11"
 *     
 */

#include <ESP8266WiFi.h>
#include <SSD1306Wire.h>
#include <TimeLib.h>
#include <NtpClientLib.h>
#include <DHT.h>


// Initialisiert das OLED Display 
SSD1306Wire  display(0x3c, 4, 5);


boolean connect_to_WLAN(); //eine Funktion um die WLAN Verbindung aufzubauen, siehe unten
boolean WLAN_connect_status =false;

//const char* ssid = "mein_wlan_name";  //hier eigenen WLAN Namen (SSID) eintragen 
//const char* password = "mein_wlan_passwort"; //hier eigenes WLAN Passwort eintragen


boolean syncEventTriggered = false; // wahr falls ein Zeit-Event getriggert wurde
NTPSyncEvent_t ntpEvent; // letztes getriggertes Event

#define DHT_TYPE DHT11   // Sensortyp definieren DHT11 
const int DHT_PIN = 14;  // Datenleitung des Sensors an GPIO14 des IoT Bricks
char temp[20];
char humi[20];
char tempSerial[20];
char gradC[4]={' ','°','C','\0'};

DHT dht(DHT_PIN, DHT_TYPE);   // Variable vom Typ DHT definieren

int counter = 0;

void setup() {
  Serial.begin(115200);
  // Initialisiert das OLED Display.
  display.init();

  //display.flipScreenVertically();
  display.setFont(ArialMT_Plain_10);
  //Variable für den erfolgreichen oder nicht erfolgreichen WLAN Connect
  WLAN_connect_status = connect_to_WLAN(); //Verbinde zum WLAN Netz

  if(WLAN_connect_status){
    NTP.begin("pool.ntp.org", 1, true);
    NTP.setInterval(63); // Aktualisierungsintervall setzen
    }

  NTP.onNTPSyncEvent([](NTPSyncEvent_t event) {
        ntpEvent = event;
        syncEventTriggered = true;
    });

   dht.begin(); // Sensor initialisieren

}

void loop() {
  
    if (digitalRead(0)==LOW){     // wenn Taste gedrückt wird, zeige die Konfiguration
 
    String state = "N/A";
      if (WiFi.status() == 0) state = "Idle";
      else if (WiFi.status() == 1) state = "NO SSID AVAILBLE";
      else if (WiFi.status() == 2) state = "SCAN COMPLETED";
      else if (WiFi.status() == 3) state = "CONNECTED";
      else if (WiFi.status() == 4) state = "CONNECT FAILED";
      else if (WiFi.status() == 5) state = "CONNECTION LOST";
      else if (WiFi.status() == 6) state = "DISCONNECTED";
      display.clear();
      display.setTextAlignment(TEXT_ALIGN_LEFT);
      display.setFont(ArialMT_Plain_10);
      String wlan_oled= "WLAN: " + (String)WiFi.SSID() +" "+ (String)WiFi.RSSI()+" dBm";    //String für WLAN Namen und Signalstärke
      display.drawString(5, 0, wlan_oled);
      display.drawString(5, 10, state); 
      String ip_oled ="IP: " + (String)WiFi.localIP()[0] + "." + (String)WiFi.localIP()[1] + "." + (String)WiFi.localIP()[2] + "." + (String)WiFi.localIP()[3];  //IP Adresse
      display.drawString(5, 20, ip_oled); 
      String gw_oled= "GW: " + (String)WiFi.gatewayIP()[0] + "." + (String)WiFi.gatewayIP()[1] + "." + (String)WiFi.gatewayIP()[2] + "." + (String)WiFi.gatewayIP()[3]; //IP Gateway
      display.drawString(5, 30, gw_oled);
      String mask_oled= "NET: " + (String)WiFi.subnetMask()[0] + "." + (String)WiFi.subnetMask()[1] + "." + (String)WiFi.subnetMask()[2] + "." + (String)WiFi.subnetMask()[3]; //Subnetzmaske
      display.drawString(5, 40, mask_oled);
      display.display();
    } else {
      if(counter%250==0){ //Infos seriell nicht zu oft ausgeben
        if (syncEventTriggered) { //Zeitevent triggern
          processSyncEvent(ntpEvent);
          syncEventTriggered = false;
        }
      Serial.print(NTP.getTimeDateString()); Serial.print(" ");
      Serial.print(NTP.isSummerTime() ? "Summer Time. " : "Winter Time. ");
      Serial.print("WiFi is ");
      Serial.print(WiFi.isConnected() ? "connected" : "not connected"); Serial.print(". ");
      Serial.print("Uptime: ");
      Serial.print(NTP.getUptimeString()); Serial.print(" since ");
      Serial.println(NTP.getTimeDateString(NTP.getFirstSync()).c_str());
      //Zur korrekten Darstellung des Grad-Zeichens "°" im seriellen Monitor ist Trick mit hexadezimal codierter Ausgabe via Serial.write(0xB0) nötig
      Serial.print("Temperatur: "); Serial.print(tempSerial);  Serial.print(" "); Serial.write(0xB0);  Serial.print("C");
      //Serial.print(gradC); 
      Serial.print(" / Feuchtigkeit: ");  Serial.println(humi);
      }
      
      String time = NTP.getTimeStr();
      String date = NTP.getDateStr();
      display.clear();
      display.setTextAlignment(TEXT_ALIGN_LEFT);
      display.setFont(ArialMT_Plain_16);
      display.drawString(5, 0, time);
      display.drawString(5, 15, date);
  
      if (counter%1000==0){               //Sensor etwa einmal pro Sekunde abfragen
        float t = dht.readTemperature();  //Temperatur auslesen (Celsius)  
        float h = dht.readHumidity();    //Feuchtigkeit auslesen (Prozent)        

        sprintDouble(temp,t,2);  //Temperatur mit 2 Nachkommastellen in String konvertieren
        sprintDouble(humi,h,0);  //Feuchtigkeit ohne Nachkommastelle in String konvertieren
        sprintDouble(tempSerial,t,2);  //tempSerial speichert Temperatur ohne °C Zeichen zur korrekten Ausgabe im seriellen Monitor
        strcat(temp," °C");      //String mit °C ergänzen
        strcat(humi," %");       //String mit %-Zeichen ergänzen
      }
      display.drawString(5, 30, temp);   //Ausgabe der Temperatur vorbereiten
      display.drawString(5, 45, humi);   //Ausgabe der Feuchtigkeit vorbereiten
      display.display();                //OLED aktualisieren
    }
 counter++;
}

      
/*
 * Eine Funktion um die WLAN Verbindung aufzubauen, mit einem Fortschrittsbalken
 */
boolean connect_to_WLAN(){ //eine Funktion um die WLAN Verbindung aufzubauen
  boolean state = true;
  int i = 0;
  
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  Serial.println("");
  Serial.println("Connecting to WLAN Access Point in client mode");

  // Da manche Access Points langsamer anworten als andere, müssen wir auf die Antwort warten, 25 Zyklen
  Serial.print("Connecting ...");
  while (WiFi.status() != WL_CONNECTED) {  //solange WLAN nicht verbunden ist, zeige Fortschrittsbalken im Display und Punkte in der Console
    delay(500);
    Serial.print(".");
    int progress = i*4;
    
    display.clear();
    display.drawProgressBar(0, 32, 120, 10, progress);
    display.setTextAlignment(TEXT_ALIGN_CENTER);
    display.drawString(64, 15, String(progress) + "%");
    
    if (i > 25){
      state = false;
      break;
    }
    display.display();
    i++;
  }
  
  if (state){  //falls Verbindung erfolgreich, zeige WLAN Namen und die DHCP IP Adresse in der Console
    Serial.println("");
    Serial.print("Connected to ");
    Serial.println(ssid);
    Serial.print("IP address: ");
    Serial.println(WiFi.localIP());
  }
  else { //gebe Fehlermeldung in der Console aus, falls Verbindung fehlgeschlagen
    Serial.println("");
    Serial.println("Connection failed.");
  }
  
  return state;
}

void processSyncEvent(NTPSyncEvent_t ntpEvent) {
    if (ntpEvent) {
        Serial.print("Time Sync error: ");
        if (ntpEvent == noResponse)
            Serial.println("NTP server not reachable");
        else if (ntpEvent == invalidAddress)
            Serial.println("Invalid NTP server address");
    }
    else {
        Serial.print("Got NTP time: ");
        Serial.println(NTP.getTimeDateString(NTP.getLastNTPSync()));
    }
}

void sprintDouble( char *str, double val, byte precision){
/* 
 *  diese Funktion ermöglicht Fließkommazahlen auszugeben mit definierter Anzahl der
 *  Nachkommastellen.
 *  
 *
 */
  char st2[16];
  unsigned long frac;
  unsigned long mult = 1;
  int mant= int(val);
  byte padding = precision -1;
  byte sgn=0;

  sprintf(str,"");
  if (val < 0)  sprintf(str,"-");
  mant=abs(mant);
  sprintf(st2,"%d",mant); //prints the int part
  strcat(str,st2); 

  if( precision > 0) {
    strcat(str,".");

    while(precision--)
      mult *=10;

    if(val >= 0)
      frac = (val - int(val)) * mult;
    else
      frac = (int(val)- val ) * mult;
    unsigned long frac1 = frac;
    int cnt=precision;
    // while( frac1 /= 10 )
    while( frac1 = frac1 / 10 & cnt--  ) 
      padding--;
    while(  padding--)  strcat(str,"0");
    sprintf(st2,"%ld",frac);

    strcat(str,st2);

  }

}


