/*  Beispiel 6.6.5 "Meine erste Webseite"
*   
 *   
 *   
 */
 
#include <ESP8266WiFi.h>
#include <SSD1306Wire.h>
#include <TimeLib.h>
#include <NtpClientLib.h>
#include "ESP8266WebServer.h"
#include <DHT.h>
 
//Definitionen fuer DHT11
#define DHT_TYPE DHT11   // Sensortyp definieren DHT11 
const int DHT_PIN = 14;  //Datenleitung des Sensors an GPIO14 des IoT Bricks
char temp[20];
char humi[20];
 
DHT dht(DHT_PIN, DHT_TYPE);   //Variable vom Typ DHT definieren
 
 
// Initialisiert das OLED Display 
SSD1306Wire  display(0x3c, 4, 5);
 
boolean connect_to_WLAN(); //eine Funktion um die WLAN Verbindung aufzubauen, siehe unten
boolean WLAN_connect_status =false;
 
const char* ssid = "wlan_name";  //hier eigenes WLAN Namen (SSID) eintragen 
const char* password = "wlan_passwort"; //hier eigenes WLAN Passwort eintragen
 
// TimeClient settings
 
boolean syncEventTriggered = false; // True if a time even has been triggered
NTPSyncEvent_t ntpEvent; // Last triggered event
int counter = 0;
 
ESP8266WebServer server(80); //Webserver starten auf Port 80
 
void idle()
{
  delay(1); // 1 ms. warten
}
 
void setup() {
  Serial.begin(115200);
  // Initialisiert die OLED graphische Anzeige.
  display.init();
 
  //display.flipScreenVertically();
  display.setFont(ArialMT_Plain_10);
  //Variable für den erfolgreichen oder nicht erfolgreichen WLAN Connect
  WLAN_connect_status = connect_to_WLAN(); //Verbinde zum WLAN Netz
 
  if(WLAN_connect_status){
    NTP.begin("pool.ntp.org", 1, true);
    NTP.setInterval(63);
    }
 
  NTP.onNTPSyncEvent([](NTPSyncEvent_t event) {
        ntpEvent = event;
        syncEventTriggered = true;
    });
 
 
    server.on("/", handleRoot); //Sobald der Browser direkt auf das Stammverzeichnis zugreift, führe die Funktion handleRoot (siehe unten) aus.
    server.begin();             //ab jetzt "hoert" Server auf HTTP-Anfragen
    Serial.println("HTTP server started");
 
}
 
void loop()
{
  idle();
 
  server.handleClient(); // bediene die http Anfragen
  
  if (digitalRead(0)==LOW)     // wenn Taste gedrückt wird, zeige die Konfiguration
  {
    String state = "N/A";
    if (WiFi.status() == 0) state = "Idle";
    else if (WiFi.status() == 1) state = "NO SSID AVAILBLE";
    else if (WiFi.status() == 2) state = "SCAN COMPLETED";
    else if (WiFi.status() == 3) state = "CONNECTED";
    else if (WiFi.status() == 4) state = "CONNECT FAILED";
    else if (WiFi.status() == 5) state = "CONNECTION LOST";
    else if (WiFi.status() == 6) state = "DISCONNECTED";
    display.clear();
    display.setTextAlignment(TEXT_ALIGN_LEFT);
    display.setFont(ArialMT_Plain_10);
    String wlan_oled= "WLAN: " + (String)WiFi.SSID() +" "+ (String)WiFi.RSSI()+" dBm";    //String für WLAN Namen und Signalstärke
    display.drawString(5, 0 , wlan_oled);
    display.drawString(5, 10 , state); 
    String ip_oled ="IP: " + (String)WiFi.localIP()[0] + "." + (String)WiFi.localIP()[1] + "." + (String)WiFi.localIP()[2] + "." + (String)WiFi.localIP()[3];  //IP Adresse
    display.drawString(5, 20 , ip_oled); 
    String gw_oled= "GW: " + (String)WiFi.gatewayIP()[0] + "." + (String)WiFi.gatewayIP()[1] + "." + (String)WiFi.gatewayIP()[2] + "." + (String)WiFi.gatewayIP()[3]; //IP Gateway
    display.drawString(5, 30 , gw_oled);
    String mask_oled= "NET: " + (String)WiFi.subnetMask()[0] + "." + (String)WiFi.subnetMask()[1] + "." + (String)WiFi.subnetMask()[2] + "." + (String)WiFi.subnetMask()[3]; //Subnetzmaske
    display.drawString(5, 40 , mask_oled);
    display.display();
  }
  else
  {
    idle();
    if (counter%250==0) //Infos seriell nicht zu oft ausgeben (ca. alle 2 Sekunden)
    {
      Serial.print(NTP.getTimeDateString()); Serial.print(" ");
      Serial.print(NTP.isSummerTime() ? "Summer Time. " : "Winter Time. ");
      Serial.print("WiFi is ");
      Serial.print(WiFi.isConnected() ? "connected" : "not connected");
      Serial.println(". ");
      Serial.print("Uptime: ");
      Serial.print(NTP.getUptimeString()); Serial.print(" since ");
      Serial.println(NTP.getTimeDateString(NTP.getFirstSync()).c_str());
    }
    String time = NTP.getTimeStr();
    String date = NTP.getDateStr();
    idle();
    display.clear();
    display.setTextAlignment(TEXT_ALIGN_LEFT);
    display.setFont(ArialMT_Plain_16);
    display.drawString(5, 0, time);
    display.drawString(5, 15, date);
    idle();
 
    if (counter%1000==0)  //Sensor etwa alle 10 Sekunden abfragen
    {
      Serial.print("Reading Sensors... ");
      idle();
      float t = dht.readTemperature();  //Temperatur auslesen (Celsius)
      idle();
      if (not(isnan(t)))
      {
        sprintDouble(temp,t,2);  //Temperatur mit 2 Nachkommastellen in String konvertieren
        //sprintDouble(tempSerial,t,2);  //tempSerial speichert Temperatur ohne °C Zeichen zur korrekten Ausgabe im seriellen Monitor
        strcat(temp," °C");      //String mit °C ergänzen
      }
      else
      {
        Serial.print("No Temperature Sensor. ");
      }
      idle();
      float h = dht.readHumidity();    //Feuchtigkeit auslesen (Prozent)
      idle();
      if (not(isnan(h)))
      {
        sprintDouble(humi,h,0);  //Feuchtigkeit ohne Nachkommastelle in String konvertieren
        strcat(humi," %");       //String mit %-Zeichen ergänzen
      }
      else
      {
        Serial.print("No Humidity Sensor. ");
      }
      Serial.println("");
    }
 
    idle();
    display.drawString(5, 30, temp);   //Ausgabe der Temperatur vorbereiten
    display.drawString(5, 45, humi);   //Ausgabe der Feuchtigkeit vorbereiten
    display.display();                 //OLED aktualisieren
  }
  counter++;
}
 
     
/*
* Eine Funktion um die WLAN Verbindung aufzubauen, mit einem Fortschrittsbalken
*/
boolean connect_to_WLAN() //eine Funktion um die WLAN Verbindung aufzubauen
{
  boolean state = true;
  int i = 0;
  
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  Serial.print(char(12));
  Serial.println("Connecting to WLAN Access Point in client mode");
 
  // Da manche Access Points langsamer antworten als andere, müssen wir auf die Antwort warten, 25 Zyklen
  Serial.print("Connecting ...");
  while (WiFi.status() != WL_CONNECTED)  //solange WLAN nicht verbunden ist, zeige Fortschrittsbalken im Display und Punkte in der Console
  {
    delay(500);
    Serial.print(".");
    int progress = i*4;
    
    display.clear();
    display.drawProgressBar(0, 32, 120, 10, progress);
    display.setTextAlignment(TEXT_ALIGN_CENTER);
    display.drawString(64, 15, String(progress) + "%");
    
    if (i > 25)
    {
      state = false;
      break;
    }
    display.display();
    i++;
  }
  
  if (state)  //falls Verbindung erfolgreich, zeige WLAN-Namen und die DHCP IP-Adresse in der Console
  {
    Serial.println("");
    Serial.print("Connected to ");
    Serial.println(ssid);
    Serial.print("IP address: ");
    Serial.println(WiFi.localIP());
  }
  else //gebe Fehlermeldung in der Console aus, falls Verbindung fehlgeschlagen
  {
    Serial.println("");
    Serial.println("Connection failed.");
  }
  
  return state;
}
 
void processSyncEvent(NTPSyncEvent_t ntpEvent)
{
    if (ntpEvent) {
        Serial.print("Time Sync error: ");
        if (ntpEvent == noResponse)
            Serial.println("NTP server not reachable");
        else if (ntpEvent == invalidAddress)
            Serial.println("Invalid NTP server address");
    }
    else {
        Serial.print("Got NTP time: ");
        Serial.println(NTP.getTimeDateString(NTP.getLastNTPSync()));
    }
}
 
//Mit der Funktion handleRoot() wird die Website ausgeliefert 
//sobald eine Anfrage von einem Browser eintrifft
 
void handleRoot()
{
  String content;
  String time_web = NTP.getTimeStr();
  String date_web = NTP.getDateStr();
  String temp_web = temp;
  String humi_web = humi;
  content = "<!DOCTYPE html>";
  content += "<html>";
  content += "<head>";
  //Falls du die Werte auf deiner Website aktualisieren möchtest kannst du folgende Zeile verwenden. Vorher musst du die IP-Adresse durch die von deinem IoT Brick ersetzen
  //content += "<meta http-equiv=\"refresh\" content=\"5; URL=http://192.168.1.153\">";  // zur automatischen Aktualisierung der Seite nach 5 Sekunden
  content += "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">";  // wichtig, damit das Grad-Zeichen "°" korrekt dargestellt wird
  content += "<title>Meine erste IoT Brick-Website</title>";
  content += "</head>";
  content += "<body>";
  content += "<h1> Hello World! </h1>";
  content += "<p>Das ist eine sehr einfache Website von deinem IoT Brick, die Datum, Uhrzeit, Temperatur und Feuchtigkeit anzeigt.</p>";
  content += "<h2>Datum: "+date_web+"</h2>";
  content += "<h2>Uhrzeit: "+time_web+"</h2>";
  content += "<h2>Temperatur: "+temp_web+"</h2>";
  content += "<h2>Feuchte: "+humi_web+"</h2>";
  content += "<p>Durch Neuladen der Website können die Werte jederzeit aktualisiert werden.</p>";
  content += "</body>";
  content += "</html>";
  server.send(200, "text/html", content);   // HTTP-Statuscode 200 = OK (Anfrage wurde erfolgreich bearbeitet)
}
 
void sprintDouble( char *str, double val, byte precision)
{
/* 
 *  Diese Funktion ermöglicht Fließkommazahlen auszugeben mit definierter 
 *  Anzahl an Nachkommastellen.
*  
 */
  char st2[16];
  unsigned long frac;
  unsigned long mult = 1;
  int mant= int(val);
  byte padding = precision -1;
  byte sgn=0;
 
  sprintf(str,"");
  if (val < 0)  sprintf(str,"-");
  mant=abs(mant);
  sprintf(st2,"%d",mant); //prints the int part
  strcat(str,st2); 
 
  if( precision > 0) {
    strcat(str,".");
 
    while(precision--)
      mult *=10;
 
    if (val >= 0)
      frac = (val - int(val)) * mult;
    else
      frac = (int(val)- val ) * mult;
    unsigned long frac1 = frac;
    int cnt=precision;
    // while( frac1 /= 10 )
    while( frac1 = frac1 / 10 & cnt--  ) 
      padding--;
    while(  padding--)  strcat(str,"0");
    sprintf(st2,"%ld",frac);
 
    strcat(str,st2);
  }
}

