/*  Beispiel 6.6.6 "LEDs via Website schalten"
 *   
 *   Die Bilddateien sowie die CSS und JavaScript Dateien aus dem Verzeichnis "data"
 *   (siehe Unterverzeichnis im Beispiel_6.6.6) , müssen mit dem "ESP8266 Sketch Data Upload" 
 *   Tool übertragen werden.
 *  
 */

#include <ESP8266WiFi.h>
#include <SSD1306Wire.h>
#include <TimeLib.h>
#include <NtpClientLib.h>
#include "ESP8266WebServer.h"
#include "FS.h"



// Initialisiert das OLED Display 
SSD1306Wire  display(0x3c, 4, 5);


boolean connect_to_WLAN(); //eine Funktion um die WLAN Verbindung aufzubauen, siehe unten
boolean WLAN_connect_status =false;

//const char* ssid = "mein_wlan_name";  //hier eigenes WLAN Namen (SSID) eintragen 
//const char* password = "mein_wlan_passwort"; //hier eigenes WLAN Passwort eintragen

// TimeClient settings

boolean syncEventTriggered = false; // True if a time even has been triggered
NTPSyncEvent_t ntpEvent; // Last triggered event
int counter = 0;

ESP8266WebServer server(80); //Webserver starten auf Port 80

int gpio13 = 13;
int gpio14 = 14;
String gpio13Name = "GPIO13";
String gpio14Name = "GPIO14";
int dOn = HIGH;
int dOff = LOW;

void setup() {
  Serial.begin(115200);
  // Initialisiert die OLED-Anzeige.
  display.init();

  //display.flipScreenVertically();
  display.setFont(ArialMT_Plain_10);
  //Variable für den erfolgreichen oder nicht erfolgreichen WLAN Connect
  WLAN_connect_status = connect_to_WLAN(); //Verbinde zum WLAN Netz

  if(WLAN_connect_status){
    NTP.begin("pool.ntp.org", 1, true);
    NTP.setInterval(63);
    }

  NTP.onNTPSyncEvent([](NTPSyncEvent_t event) {
        ntpEvent = event;
        syncEventTriggered = true;
    });

    server.on("/", handleRoot); //wenn der Browser direkt auf das Stammverzeichnis zugreift, führe die Funktion handleRoot (siehe unten) aus.
    /*  Folgende Einträge bestimmen, welche Funktionen ausgeführt werden wenn man bestimmte Links im Browser aufruft,
     *  falls z.B. der IoT Brick die IP Adresse 192.168.1.153 vom DHCP Server erhalten hat, dann würde das Ausrufen der 
     *  Adresse http://192.168.1.153/img/brklogo.png dazu führen, dass die Funktion handleImgLogo ausgeführt wird, die wiederum 
     *  die Bilddatei brklogo.png aus dem internen Dateisystem (SPIFFS) liest und an den Webserver liefert.  
     */
     
    // JS (Javascript)
    server.on("/js/jquery", handleJsJquery);
    server.on("/js/bootstrap", handleJsBootstrap);
    server.on("/js/bootstrap-switch", handleJsBootstrapSwitch);
    // CSS (Cascaded Style Sheets 
    server.on("/css/bootstrap", handleCssBootstrap);
    server.on("/css/bootstrap-switch", handleCssBootstrapSwitch);
    // Images (Bilder)
    server.on("/img/bg.png", handleImgBg);
    server.on("/img/brklogo.png", handleImgLogo);

    // WebServer Handles für die GPIO Schaltfunktionen
    server.on("/switch13-on", handleGpio13On);
    server.on("/switch13-off", handleGpio13Off);
    server.on("/switch14-on", handleGpio14On);
    server.on("/switch14-off", handleGpio14Off);
    
    server.begin();
    Serial.println("HTTP server started");
    setupPins();

}

void loop() {
  
    server.handleClient(); //Bediene die HTTP-Anfragen
  
    if (digitalRead(0)==LOW){     // Wenn Taste gedrückt wird, zeige die Konfiguration
 
    String state = "N/A";
      if (WiFi.status() == 0) state = "Idle";
      else if (WiFi.status() == 1) state = "NO SSID AVAILBLE";
      else if (WiFi.status() == 2) state = "SCAN COMPLETED";
      else if (WiFi.status() == 3) state = "CONNECTED";
      else if (WiFi.status() == 4) state = "CONNECT FAILED";
      else if (WiFi.status() == 5) state = "CONNECTION LOST";
      else if (WiFi.status() == 6) state = "DISCONNECTED";
      display.clear();
      display.setTextAlignment(TEXT_ALIGN_LEFT);
      display.setFont(ArialMT_Plain_10);
      String wlan_oled= "WLAN: " + (String)WiFi.SSID() +" "+ (String)WiFi.RSSI()+" dBm";    //String für WLAN Namen und Signalstärke
      display.drawString(5, 0 , wlan_oled);
      display.drawString(5, 10 , state); 
      String ip_oled ="IP: " + (String)WiFi.localIP()[0] + "." + (String)WiFi.localIP()[1] + "." + (String)WiFi.localIP()[2] + "." + (String)WiFi.localIP()[3];  //IP Adresse
      display.drawString(5, 20 , ip_oled); 
      String gw_oled= "GW: " + (String)WiFi.gatewayIP()[0] + "." + (String)WiFi.gatewayIP()[1] + "." + (String)WiFi.gatewayIP()[2] + "." + (String)WiFi.gatewayIP()[3]; //IP Gateway
      display.drawString(5, 30 , gw_oled);
      String mask_oled= "NET: " + (String)WiFi.subnetMask()[0] + "." + (String)WiFi.subnetMask()[1] + "." + (String)WiFi.subnetMask()[2] + "." + (String)WiFi.subnetMask()[3]; //Subnetzmaske
      display.drawString(5, 40 , mask_oled);
      display.display();
    } else {
      if(counter%250==0){ //Infos seriell nicht zu oft ausgeben
      Serial.print(NTP.getTimeDateString()); Serial.print(" ");
      Serial.print(NTP.isSummerTime() ? "Summer Time. " : "Winter Time. ");
      Serial.print("WiFi is ");
      Serial.print(WiFi.isConnected() ? "connected" : "not connected"); Serial.print(". ");
      Serial.print("Uptime: ");
      Serial.print(NTP.getUptimeString()); Serial.print(" since ");
      Serial.println(NTP.getTimeDateString(NTP.getFirstSync()).c_str());
      }
      String time = NTP.getTimeStr();
      String date = NTP.getDateStr();
      display.clear();
      display.setTextAlignment(TEXT_ALIGN_LEFT);
      display.setFont(ArialMT_Plain_24);
      display.drawString(15, 5 , time);
      display.drawString(5, 35 , date);
      display.display();
    }
 counter++;
}


/*
 * Eine Funktion um die WLAN Verbindung aufzubauen, mit einem Fortschrittsbalken
 */
boolean connect_to_WLAN(){ //eine Funktion um die WLAN Verbindung aufzubauen
  boolean state = true;
  int i = 0;
  
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  Serial.println("");
  Serial.println("Connecting to WLAN Access Point in client mode");

  // Da manche Access Points langsamer antworten als andere, müssen wir auf die Antwort warten, 25 Zyklen
  Serial.print("Connecting ...");
  while (WiFi.status() != WL_CONNECTED) {  //solange WLAN nicht verbunden ist, zeige Fortschrittsbalken im Display und Punkte in der Console
    delay(500);
    Serial.print(".");
    int progress = i*4;
    
    display.clear();
    display.drawProgressBar(0, 32, 120, 10, progress);
    display.setTextAlignment(TEXT_ALIGN_CENTER);
    display.drawString(64, 15, String(progress) + "%");
    
    if (i > 25){
      state = false;
      break;
    }
    display.display();
    i++;
  }
  
  if (state){  //falls Verbindung erfolgreich, zeige WLAN Namen und die DHCP IP Adresse in der Console
    Serial.println("");
    Serial.print("Connected to ");
    Serial.println(ssid);
    Serial.print("IP address: ");
    Serial.println(WiFi.localIP());
  }
  else { //gebe Fehlermeldung in der Console aus, falls Verbindung fehlgeschlagen
    Serial.println("");
    Serial.println("Connection failed.");
  }
  
  return state;
}

void processSyncEvent(NTPSyncEvent_t ntpEvent) {
    if (ntpEvent) {
        Serial.print("Time Sync error: ");
        if (ntpEvent == noResponse)
            Serial.println("NTP server not reachable");
        else if (ntpEvent == invalidAddress)
            Serial.println("Invalid NTP server address");
    }
    else {
        Serial.print("Got NTP time: ");
        Serial.println(NTP.getTimeDateString(NTP.getLastNTPSync()));
    }
}

void handleRoot() {
  String content;
  String network(ssid);
  content = "<!DOCTYPE html>";
  content += "<html>";
  content += "<head>";
  content += "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">";  // wichtig, damit das Grad-Zeichen "°" korrekt dargestellt wird
  content += "<meta http-equiv=\"cache-control\" content=\"max-age=0\">";
  content += "<meta http-equiv=\"cache-control\" content=\"no-cache\">";
  content += "<meta http-equiv=\"expires\" content=\"0\">";
  content += "<meta http-equiv=\"expires\" content=\"Tue, 01 Jan 1980 1:00:00 GMT\">";
  content += "<meta http-equiv=\"pragma\" content=\"no-cache\">";
  content += "<meta http-equiv=\"Content-Language\" content=\"de_DE\">";
  content += "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">";
  content += "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, user-scalable=no\">";
  content += "<meta name=\"description\" content=\"BrickRknowledge IoT Brick-Website\">";
  content += "<meta name=\"author\" content=\"ALLNET\">";
  content += "<title>IoT Brick via WLAN "+network+" schalten</title>";
  content += "<link rel=\"stylesheet\" href=\"/css/bootstrap\">";
  content += "<link rel=\"stylesheet\" href=\"/css/bootstrap-switch\">";
  content += "<style>body{background-image:url(/img/bg.png);margin:0;padding:20px;background-size:100% auto;background-repeat:no-repeat;font-family:\"Helvetica Neue\",Helvetica,Arial,sans-serif;font-size:14px;line-height:1.5;color:#333;background-color:#fff}.col-sm-2{margin-top:20px}.img-thumbnail{border:0}</style>";
  content += "</head>";
  content += "<body>";
  content += "<div class=\"container-fluid\">";
  content += "<div class=\"row\">";
  content += "<div class=\"col-sm-2\"><img class=\"img-thumbnail\" src=\"/img/brklogo.png\"></div>";
  content += "</div>";
  content += "<div class=\"row\">";
  content += "<div class=\"col-sm-2\"><input type=\"checkbox\" id=\"switch14\" data-label-text=\""+gpio14Name+"\" data-label-width=\"120\"></div>";
  content += "<div class=\"col-sm-2\"><input type=\"checkbox\" id=\"switch13\" data-label-text=\""+gpio13Name+"\" data-label-width=\"120\"></div>";
  content += "</div>";
  content += "</div>";
  content += "<script src=\"/js/jquery\"></script>";
  content += "<script src=\"/js/bootstrap\"></script>";
  content += "<script src=\"/js/bootstrap-switch\"></script>";
  content += "<script type=\"text/javascript\">";
  content += "$('input[type=\"checkbox\"]').bootstrapSwitch({onSwitchChange:function(){$.ajax({url:'/'+$(this).prop('id')+'-'+($(this).prop('checked')?'on':'off')});}});";
  content += "var setAdc=function(){$.ajax({url:'/adc'}).done(function(data){data=data||{};if(data.hasOwnProperty('data')){$('#adc').text(data.data);}}).fail(function(jqxhr,textStatus,error){}).always(function(){setTimeout(setAdc,1000);});};setAdc();";
  content += "</script>";
  content += "</body>";
  content += "</html>";
  server.send(200, "text/html", content);   // HTTP-Statuscode 200 = OK (Anfrage wurde erfolgreich bearbeitet)
}

/*****************************************************************************************
 * Für alle die sich schon gut mit HTML auskennen und selbst die Website modifizieren 
 * möchten, finden im Folgenden den HTML-Code aus der Funktion handleRoot() "im Klartext". 
 * Am besten du kopiert ihn in einen HTML-Editor deiner Wahl.
 * ***************************************************************************************
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta http-equiv="cache-control" content="max-age=0">
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="expires" content="0">
<meta http-equiv="expires" content="Tue, 01 Jan 1980 1:00:00 GMT">
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="Content-Language" content="de_DE">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no"><meta name="description" content="BrickRknowledge IoT Brick Website">
<meta name="author" content="ALLNET">
<title>IoT Brick via "+network+" schalten</title>
<link rel="stylesheet" href="/css/bootstrap">
<link rel="stylesheet" href="/css/bootstrap-switch">
<style>
body{background-image:url(/img/bg.png);margin:0;padding:20px;background-size:100% auto;background-repeat:no-repeat;font-family:"Helvetica Neue",Helvetica,Arial,sans-serif;font-size:14px;line-height:1.5;color:#333;background-color:#fff}.col-sm-2{margin-top:20px}.img-thumbnail{border:0}
</style>
</head>
<body>
<div class="container-fluid">
<div class="row">
<div class="col-sm-2">
<img class="img-thumbnail" src="/img/brklogo.png">
</div>
</div>
<div class="row">
<div class="col-sm-2">
<input type="checkbox" id="switch13" data-label-text="gpio13Name" data-label-width="120">
</div>
<div class="col-sm-2">
<input type="checkbox" id="switch14" data-label-text="gpio14Name+" data-label-width="120">
</div>
</div>
</div>
<script src="/js/jquery"></script>
<script src="/js/bootstrap"></script>
<script src="/js/bootstrap-switch"></script>
<script type="text/javascript">$('input[type="checkbox"]').bootstrapSwitch({onSwitchChange:function(){$.ajax({url:'/'+$(this).prop('id')+'-'+($(this).prop('checked')?'on':'off')});}});var setAdc=function(){$.ajax({url:'/adc'}).done(function(data){data=data||{};if(data.hasOwnProperty('data')){$('#adc').text(data.data);}}).fail(function(jqxhr,textStatus,error){}).always(function(){setTimeout(setAdc,1000);});};setAdc();</script>
</body>
</html>
******************************
*    Ende des HTML-Codes     *
******************************
*/


// GPIO 13 und 14 werden als Ausgang konfiguriert um die LEDs schalten zu können
 void setupPins() {
  pinMode(gpio13, OUTPUT);
  pinMode(gpio14, OUTPUT);
  digitalWrite(gpio13, dOff);
  digitalWrite(gpio14, dOff);
}

//Handle-Funktion für GPIO13 ON
 void handleGpio13On() {
  digitalWrite(gpio13, dOn);
  server.send(200, "text/html", gpio13Name+" on");
}
//Handle-Funktion für GPIO13 OFF
void handleGpio13Off() {
  digitalWrite(gpio13, dOff);
  server.send(200, "text/html", gpio13Name+" off");
}

//Handle-Funktion für GPIO14 ON
void handleGpio14On() {
  digitalWrite(gpio14, dOn);
  server.send(200, "text/html", gpio14Name+" on");
}
//Handle-Funktion für GPIO14 OFF
void handleGpio14Off() {
  digitalWrite(gpio14, dOff);
  server.send(200, "text/html", gpio14Name+" off");
}

/*
 * Folgende Funktionen sind notwendig um diverse Dateien die JQuery und JavaScript Funktionen
 * beinhalten aus dem internen Filesystem (SPIFFS definiert in FS.h) des IoT Bricks auszulesen 
 * und dem WebServer zur Verfügung zu stellen.
 */

void handleJsJquery() {
  String path = "/jquery.js.gz";
  SPIFFS.begin();
  File f = SPIFFS.open(path, "r");
  if(f) {
    f.setTimeout(0);
    size_t sent = server.streamFile(f, "application/javascript");
    f.close();
  } else {
    Serial.println("JsJquery open failed");
  }
  SPIFFS.end();
}

void handleJsBootstrap() {
  String path = "/bootstrap.js.gz";
  SPIFFS.begin();
  File f = SPIFFS.open(path, "r");
  if(f) {
    f.setTimeout(0);
    size_t sent = server.streamFile(f, "application/javascript");
    f.close();
  } else {
    Serial.println("JsBootstrap open failed");
  }
  SPIFFS.end();
}

void handleJsBootstrapSwitch() {
  String path = "/bootstrap-switch.js.gz";
  SPIFFS.begin();
  File f = SPIFFS.open(path, "r");
  if(f) {
    f.setTimeout(0);
    size_t sent = server.streamFile(f, "application/javascript");
    f.close();
  } else {
    Serial.println("JsBootstrapSwitch open failed");
  }
  SPIFFS.end();
}

void handleCssBootstrap() {
  String path = "/bootstrap.css.gz";
  SPIFFS.begin();
  File f = SPIFFS.open(path, "r");
  if(f) {
    f.setTimeout(0);
    size_t sent = server.streamFile(f, "text/css");
    f.close();
  } else {
    Serial.println("CssBootstrap open failed");
  }
  SPIFFS.end();
}

void handleCssBootstrapSwitch() {
  String path = "/bootstrap-switch.css.gz";
  SPIFFS.begin();
  File f = SPIFFS.open(path, "r");
  if(f) {
    f.setTimeout(0);
    size_t sent = server.streamFile(f, "text/css");
    f.close();
  } else {
    Serial.println("CssBootstrapSwitch open failed");
  }
  SPIFFS.end();
}

void handleImgBg() {
  String path = "/bg.png";
  SPIFFS.begin();
  File f = SPIFFS.open(path, "r");
  if(f) {
    f.setTimeout(0);
    size_t sent = server.streamFile(f, "image/png");
    f.close();
  } else {
    Serial.println("ImgBg open failed");
  }
  SPIFFS.end();
}

void handleImgLogo() {
  String path = "/brklogo.png";
  SPIFFS.begin();
  File f = SPIFFS.open(path, "r");
  if(f) {
    f.setTimeout(0);
    size_t sent = server.streamFile(f, "image/png");
    f.close();
  } else {
    Serial.println("ImgBrklogo open failed");
  }
  SPIFFS.end();
}


